//								EJEMPLO 22
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El TMR1 en el modo temporizador
//
//Se desea realizar un contador binario visualizado sobre la Puerta B que, se vaya incremen-
//tando a razn de una unidad cada 0.1 segundos. Para ello contamos con la ayuda de la
//interrupcin provocada por el TMR1

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)

int	 temporal=0;

#int_timer1				//Tratamiento de interrupcin del TMR1
tratamiento()
{	
		set_timer1(~12500);			//Repone TMR1 con 12500
		temporal++	;				//Incrementa el contador
		output_b(temporal);			//Visualiza el contador
}

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	output_b(0x00);				//Borra salidas
	set_tris_b(0x00);			//RB0-RB7 salidas
	enable_interrupts(int_timer1);	//Activa interrupcin del Timer1

/*El TMR1 trabaja con oscilador interno y un preescaler de 1:8. Si se trabaja a una frecuencia
de 4 MHz, el TMR1 deber ser cargado con 12500 para que provoque interrupcin al de 0.1s
(12500 * 8 * 1 =100000uS=0.1")*/

	set_timer1(~12500);			//Carga TMR1 con 12500
	setup_timer_1(T1_INTERNAL | T1_DIV_BY_8);	//TMR1 ON y 1:8		
	enable_interrupts(global);	//Habilita interrupciones

	while(1)
	{	
		
	}
}	
